// @ts-nocheck

$(document).ready(function () {

    /// START :: ACTIVE MENU CODE
    $(".menu a").each(function () {
        let pageUrl = window.location.href.split(/[?#]/)[0];
        if (this.href == pageUrl) {
            $(this).parent().parent().addClass("active");
            $(this).parent().addClass("active"); // add active to li of the current link
            $(this).parent().parent().prev().addClass("active"); // add active class to an anchor
            $(this).parent().parent().parent().addClass("active"); // add active class to an anchor
            $(this).parent().parent().parent().parent().addClass("active"); // add active class to an anchor
        }

        let subURL = $("a#subURL").attr("href");
        if (subURL != 'undefined') {
            if (this.href == subURL) {
                $(this).parent().addClass("active"); // add active to li of the current link
                $(this).parent().parent().addClass("active");
                $(this).parent().parent().prev().addClass("active"); // add active class to an anchor
                $(this).parent().parent().parent().addClass("active"); // add active class to an anchor
            }
        }
    });
    /// END :: ACTIVE MENU CODE


    FilePond.registerPlugin(FilePondPluginImagePreview, FilePondPluginFileValidateSize,
        FilePondPluginFileValidateType);

    if ($('.filepond').length > 0) {
        $('.filepond').filepond({
            credits: null,
            allowFileSizeValidation: "true",
            maxFileSize: '25MB',
            labelMaxFileSizeExceeded: 'File is too large',
            labelMaxFileSize: 'Maximum file size is {filesize}',
            allowFileTypeValidation: true,
            acceptedFileTypes: ['image/*'],
            labelFileTypeNotAllowed: 'File of invalid type',
            fileValidateTypeLabelExpectedTypes: 'Expects {allButLastType} or {lastType}',
            storeAsFile: true,
            allowPdfPreview: true,
            pdfPreviewHeight: 320,
            pdfComponentExtraParams: 'toolbar=0&navpanes=0&scrollbar=0&view=fitH',
            allowVideoPreview: true, // default true
            allowAudioPreview: true // default true
        });
    }


    if ($('.zip-pond').length > 0) {
        $('.zip-pond').filepond({
            credits: null,
            allowFileSizeValidation: "true",
            maxFileSize: '25MB',
            labelMaxFileSizeExceeded: 'File is too large',
            labelMaxFileSize: 'Maximum file size is {filesize}',
            allowFileTypeValidation: false,
            acceptedFileTypes: ["zip", "application/octet-stream", "application/zip", "application/x-zip", "application/x-zip-compressed", "zipx", "z01", "zx01"],
            labelFileTypeNotAllowed: 'File of invalid type',
            fileValidateTypeLabelExpectedTypes: 'Expects {allButLastType} or {lastType}',
            storeAsFile: true,
            allowPdfPreview: true,
            pdfPreviewHeight: 320,
            pdfComponentExtraParams: 'toolbar=0&navpanes=0&scrollbar=0&view=fitH',
            allowVideoPreview: true, // default true
            allowAudioPreview: true // default true
        });
    }


    //magnific popup
    $(document).on('click', '.image-popup-no-margins', function () {
        $(this).magnificPopup({
            type: 'image',
            closeOnContentClick: true,
            closeBtnInside: false,
            fixedContentPos: true,
            image: {
                verticalFit: true
            },
            zoom: {
                enabled: true,
                duration: 300 // don't forget to change the duration also in CSS
            },
            gallery: {
                enabled: true
            },
        }).magnificPopup('open');
        return false;
    });

    $('#table_list').on('load-success.bs.table', function () {
        if ($('.gallery').length > 0) {
            $('.gallery').each(function () { // the containers for all your galleries
                $(this).magnificPopup({
                    delegate: 'a', // the selector for gallery item
                    type: 'image',
                    gallery: {
                        enabled: true
                    }
                });
            });
        }
    })

    $(document).off('focusin');
});


/// START :: TinyMCE
document.addEventListener("DOMContentLoaded", () => {
    tinymce.init({
        selector: '#tinymce_editor',
        height: 400,
        menubar: true,
        plugins: [
            'advlist autolink lists link charmap print preview anchor',
            'searchreplace visualblocks code fullscreen',
            'insertdatetime table paste code help wordcount'
        ],

        toolbar: 'insert | undo redo |  formatselect | bold italic backcolor  | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | help',
        setup: function (editor) {
            editor.on("change keyup", function () {
                //tinyMCE.triggerSave(); // updates all instances
                editor.save(); // updates this instance's textarea
                $(editor.getElement()).trigger('change'); // for garlic to detect change
            });
        }
    });
});

$('body').append('<div id="loader-container"><div class="loader"></div></div>');
$(window).on('load', function () {
    $('#loader-container').fadeOut('slow');
});

setTimeout(function () {
    $(".error-msg").fadeOut(1500)
}, 5000);

document.addEventListener('touchstart', event => {
    if (event.cancelable) {
        event.preventDefault();
    }
});

document.addEventListener('touchmove', event => {
    if (event.cancelable) {
        event.preventDefault();
    }
});

document.addEventListener('touchcancel', event => {
    if (event.cancelable) {
        event.preventDefault();
    }
});

$('.status-switch').on('change', function () {
    if ($(this).is(":checked")) {
        $(this).siblings('input[type="hidden"]').val(1);
    } else {
        $(this).siblings('input[type="hidden"]').val(0);
    }
})

$('input[type="radio"][name="duration_type"]').on('click', function () {
    if ($(this).hasClass('edit_duration_type')) {
        if ($(this).is(':checked')) {
            if ($(this).val() == 'limited') {
                $('#edit_limitation_for_duration').show();
                $('#edit_durationLimit').attr("required", "true").val("");
            } else {
                // Unlimited
                $('#edit_limitation_for_duration').hide();
                $('#edit_durationLimit').removeAttr("required").val("");
            }
        }
    } else {
        if ($(this).is(':checked')) {
            if ($(this).val() == 'limited') {
                $('#limitation_for_duration').show();
                $('#durationLimit').attr("required", "true").val("");
            } else {
                // Unlimited
                $('#limitation_for_duration').hide();
                $('#durationLimit').removeAttr("required").val("");
            }
        }
    }
});

$('input[type="radio"][name="item_limit_type"]').on('click', function () {
    if ($(this).hasClass('edit_item_limit_type')) {
        if ($(this).is(':checked')) {
            if ($(this).val() == 'limited') {
                $('#edit_limitation_for_limit').show();
                $('#edit_ForLimit').attr("required", "true");
            } else {
                // Unlimited
                $('#edit_limitation_for_limit').hide();
                $('#edit_ForLimit').val('');
                $('#edit_ForLimit').removeAttr("required");
            }
        }
    } else {
        if ($(this).is(':checked')) {
            if ($(this).val() == 'limited') {
                $('#limitation_for_limit').show();
                $('#durationForLimit').attr("required", "true");
            } else {
                // Unlimited
                $('#limitation_for_limit').hide();
                $('#durationForLimit').removeAttr("required");
            }
        }
    }
});

$('#filter').change(function () {
    let selectedValue = $(this).val();
    // Hide all criteria elements initially
    $('#category_criteria, #price_criteria').hide();
    // Show the relevant criteria based on the selected option
    if (selectedValue === "category_criteria") {
        $('#category_criteria').show();
    } else if (selectedValue === "price_criteria") {
        $('#price_criteria').show();
    }
});

$('#user_notification_list').on('check.bs.table  uncheck.bs.table', function () {
    let fcm_list = [];
    let user_list = [];
    let data = $("#user_notification_list").bootstrapTable('getSelections');
    data.forEach(function (value) {
        if (value.fcm_id != "") {
            fcm_list.push(value.fcm_id);
        }
        if (value.id != "") {
            user_list.push(value.id);
        }
    })

    $('textarea#fcm_id').text(fcm_list);
    $('textarea#user_id').text(user_list);
});

$('#delete_multiple').on('click', function (e) {
    e.preventDefault();
    let table = $('#table_list');
    let selected = table.bootstrapTable('getSelections');
    let ids = "";

    $.each(selected, function (i, e) {
        ids += e.id + ",";
    });
    ids = ids.slice(0, -1);
    if (ids == "") {
        showErrorToast(trans('Please Select Notification First'));
    } else {
        showDeletePopupModal($(this).attr('href'), {
            data: {
                id: ids
            }, successCallBack: function () {
                $('#table_list').bootstrapTable('refresh');
            }
        })
    }
});


$(".checkbox-toggle-switch").on('change', function () {
    let inputValue = $(this).is(':checked') ? 1 : 0;
    $(this).siblings(".checkbox-toggle-switch-input").val(inputValue);
});

$('.toggle-button').on('click', function (e) {
    e.preventDefault();
    $(this).closest('.category-header').next('.subcategories').slideToggle();
});

let length = $('#sub_category_count').val();

for (let i = 1; i <= length; i++) {
    $('.child_category_list' + i).hide();
    $('#sub_category' + i).change(function () {
        $('#child_category' + i).prop("checked", $(this).is(":checked"));
    });

    $('#category_arrow' + i).on('click', function () {
        $('.child_category_list' + i).toggle();
    });
}

$('#type').on('change', function () {
    if ($.inArray($(this).val(), ['checkbox', 'radio', 'dropdown']) > -1) {
        $('#field-values-div').slideDown(500);
        $('.min-max-fields').slideUp(500);
    } else {
        $('#field-values-div').slideUp(500);
        $('.min-max-fields').slideDown(500);
    }
});

$('.image').on('change', function () {
    const allowedExtensions = /(\.jpg|\.jpeg|\.png|\.gif)$/i;
    const fileInput = this;
    const [file] = fileInput.files;
    if (!file) {
        return; // No file selected
    }

    if (!allowedExtensions.exec(file.name)) {
        $('.img_error').text('Invalid file type. Please choose an image file.');
        fileInput.value = '';
        return;
    }

    const maxFileSize = 2 * 1024 * 1024; // 5MB (adjust as needed)
    if (file.size > maxFileSize) {
        $('.img_error').text('File size exceeds the maximum allowed size (2MB).');
        fileInput.value = '';
    }
    if (file) {
        $(this).siblings('.preview-image').attr('src', URL.createObjectURL(file))
    }
});

$(".toggle-password").on('click', function () {
    $(this).toggleClass("bi bi-eye bi-eye-slash");
    let input = $(this).parent().siblings("input");
    if (input.attr("type") == "password") {
        input.attr("type", "text");
    } else {
        input.attr("type", "password");
    }
});

$('#price,#discount_in_percentage').on('input', function () {
    let price = $('#price').val();
    let discount = $('#discount_in_percentage').val();
    let final_price = calculateDiscountedAmount(price, discount);
    $('#final_price').val(final_price);
})

$('#final_price').on('input', function () {
    let discountedPrice = $(this).val();
    let price = $('#price').val();
    let discount = calculateDiscount(price, discountedPrice);
    $('#discount_in_percentage').val(discount);
})


$('#edit_price,#edit_discount_in_percentage').on('input', function () {
    let price = $('#edit_price').val();
    let discount = $('#edit_discount_in_percentage').val();
    let final_price = calculateDiscountedAmount(price, discount);
    $('#edit_final_price').val(final_price);
})

$('#edit_final_price').on('input', function () {
    let discountedPrice = $(this).val();
    let price = $('#edit_price').val();
    let discount = calculateDiscount(price, discountedPrice);
    $('#edit_discount_in_percentage').val(discount);
})
$('#slug').bind('keyup blur', function () {
    $(this).val($(this).val().replace(/[^A-Za-z0-9-]/g, ''))
});

function toggleRejectedReasonVisibility() {
    var status = $('#status').val();
    var rejectedReasonContainer = $('#rejected_reason_container');
    if (status === 'rejected') {
        rejectedReasonContainer.show();
    } else {
        rejectedReasonContainer.hide();
    }
}

$('.editdata, #status').on('click change', function () {
    toggleRejectedReasonVisibility();
});

$(document).on('change', '.update-item-status', function () {
    let url = window.baseurl + "common/change-status";
    ajaxRequest('PUT', url, {
        id: $(this).attr('id'),
        table: "items",
        column: "deleted_at",
        status: $(this).is(':checked') ? 1 : 0
    }, null, function (response) {
        showSuccessToast(response.message);
    }, function (error) {
        showErrorToast(error.message);
    })
})

$(document).on('change', '.update-user-status', function () {
    let url = window.baseurl + "common/change-status";
    ajaxRequest('PUT', url, {
        id: $(this).attr('id'),
        table: "users",
        column: "deleted_at",
        status: $(this).is(':checked') ? 1 : 0
    }, null, function (response) {
        showSuccessToast(response.message);
    }, function (error) {
        showErrorToast(error.message);
    })
})

$('#switch_banner_ad_status').on('change', function () {
    $('#banner_ad_id_android').attr('required', $(this).is(':checked'));
    $('#banner_ad_id_ios').attr('required', $(this).is(':checked'));
})

$('.package_type').on('change', function () {
    if ($(this).val() == 'item_listing') {
        $('#item-listing-package-div').show();
        $('#advertisement-package-div').hide();

        $('#item-listing-package').attr('required', true);
        $('#advertisement-package').attr('required', false);
    } else if ($(this).val() == 'advertisement') {
        $('#item-listing-package-div').hide();
        $('#advertisement-package-div').show();

        $('#advertisement-package').attr('required', true);
        $('#item-listing-package').attr('required', false);
    }
});

$('.package').on('change', function () {
    let package_detail = $(this).find('option:selected').data('details');
    if (package_detail != null) {
        $('#package_details').show();
        $('.payment').show();
    } else {
        $('#package_details').hide();
        $('.payment').hide();
        $('.cheque').hide();
    }
    $("#package_name").text(package_detail?.name);
    $("#package_price").text(package_detail?.price);
    $("#package_final_price").text(package_detail?.final_price);
    $("#package_duration").text(package_detail?.duration);
});
$('.payment_gateway').change(function () {
    if ($(this).val() == 'cheque') {
        $('.cheque').show();
    } else {
        $('.cheque').hide();
    }

    $('.payment').val('').trigger('change');
});


$('#switch_interstitial_ad_status').on('change', function () {
    $('#interstitial_ad_id_android').attr('required', $(this).is(':checked'));
    $('#interstitial_ad_id_ios').attr('required', $(this).is(':checked'));
})

$('#country').on('change', function () {
    let countryId = $(this).val();
    let url = window.baseurl + 'states/search?country_id=' + countryId;
    ajaxRequest('GET', url, null, null, function (response) {
        $('#state').html("<option value=''>" + window.trans("--Select State--") + "</option>")
        $.each(response.data, function (key, value) {
            $('#state').append($('<option>', {
                value: value.id,
                text: value.name
            }));
        });
    })
});

$('#state').on('change', function () {
    let stateId = $(this).val();
    let url = window.baseurl + 'cities/search?state_id=' + stateId;
    ajaxRequest('GET', url, null, null, function (response) {
        $('#city').html("<option value=''>" + window.trans("--Select City--") + "</option>")
        $.each(response.data, function (key, value) {
            $('#city').append($('<option>', {
                value: value.id,
                text: value.name
            }));
        });
    })
});

$('#filter_country').on('change', function () {
    let countryId = $(this).val();
    let url = window.baseurl + 'states/search?country_id=' + countryId;
    ajaxRequest('GET', url, null, null, function (response) {
        $('#filter_state').html("<option value=''>" + window.trans("All") + "</option>")
        $.each(response.data, function (key, value) {
            $('#filter_state').append($('<option>', {
                value: value.id,
                text: value.name
            }));
        });
    })
});

$('#filter_state').on('change', function () {
    let stateId = $(this).val();
    let url = window.baseurl + 'cities/search?state_id=' + stateId;
    ajaxRequest('GET', url, null, null, function (response) {
        $('#filter_city').html("<option value=''>" + window.trans("All") + "</option>")
        $.each(response.data, function (key, value) {
            $('#filter_city').append($('<option>', {
                value: value.id,
                text: value.name
            }));
        });
    })
});

$(document).ready(function () {
    const $addAreaButton = $('#add-area-button');
    const $areasContainer = $('#areas-container');

    $addAreaButton.on('click', function () {
        const $newAreaInputGroup = $(`
            <div class="area-input-group col-md-12">
                <label for="name" class="mandatory form-label mt-2"> Area Name</label>
                <div class="d-flex">
                    <input type="text" name="name[]" class="form-control me-2" placeholder="Enter Area name">
                    <button type="button" class="btn btn-danger remove-area-button ">-</button>
                </div>
            </div>
        `);
        $areasContainer.append($newAreaInputGroup);
    });

    // Event delegation to handle dynamically added remove buttons
    $areasContainer.on('click', '.remove-area-button', function () {
        $(this).closest('.area-input-group').remove();
    });
});

$('#switch_stripe_gateway').on('change', function () {
    let status = $(this).prop('checked');
    $('[name^="gateway[Stripe]"]').each(function () {
        $(this).prop('required', status);
    });
});

$('#switch_razorpay_gateway').on('change', function () {
    let status = $(this).prop('checked');
    $('[name^="gateway[Razorpay]"]').each(function () {
        $(this).prop('required', status);
    });
});

$('#switch_paystack_gateway').on('change', function () {
    let status = $(this).prop('checked');
    $('[name^="gateway[Paystack]"]').each(function () {
        $(this).prop('required', status);
    });
});

$('#google_map_iframe_link').on('input', function () {
    try {
        let element = $(this).val();
        let src = $(element).attr('src');
        $(this).val(src);
    } catch (err) {
        $(this).val("");
        showErrorToast("Please enter a valid map iframe")
    }

});
$('#category_name').on('input', function () {
    let name = $(this).val();
    let slug = name.toLowerCase().replace(/\s+/g, '-').replace(/[^\w-]+/g, '');
    $('#category_slug').val(slug);
});

$(document).ready(function () {
    /* Form Validation for Privacy policy */
    $('#submit_button').on('click', function (event) {
        event.preventDefault();

        // Find the TinyMCE editor in Privacy policy form
        var privacyEditor = null;
        tinymce.editors.forEach(function (editor) {
            if ($(editor.getElement()).closest('#Privacy_and_policy').length > 0) {
                privacyEditor = editor;
            }
        });

        var privacy_policy = '';
        if (privacyEditor) {
            privacy_policy = privacyEditor.getContent();
            // Update textarea with TinyMCE content
            $(privacyEditor.getElement()).val(privacy_policy);
        } else {
            // Fallback to textarea value
            privacy_policy = $('#Privacy_and_policy #tinymce_editor').val();
        }

        if (privacy_policy.trim() === "" || privacy_policy === "<p><br></p>" || privacy_policy === "<p></p>") {
            $('#privacy_policy_error').removeClass('d-none');
            return false;
        } else {
            $('#privacy_policy_error').addClass('d-none');
            $('#Privacy_and_policy').submit();
        }
    });

    /* Form Validation for Terms and conditions */
    $('#terms_and_conditions_submit').on('click', function (event) {
        event.preventDefault();

        // Find the TinyMCE editor in Terms and conditions form
        var termsEditor = null;
        tinymce.editors.forEach(function (editor) {
            if ($(editor.getElement()).closest('#terms_and_conditions_form').length > 0) {
                termsEditor = editor;
            }
        });

        var terms_and_conditions = '';
        if (termsEditor) {
            terms_and_conditions = termsEditor.getContent();
            // Update textarea with TinyMCE content
            $(termsEditor.getElement()).val(terms_and_conditions);
        } else {
            // Fallback to textarea value
            terms_and_conditions = $('#terms_and_conditions_form #tinymce_editor').val();
        }

        if (terms_and_conditions.trim() === "" || terms_and_conditions === "<p><br></p>" || terms_and_conditions === "<p></p>") {
            $('#terms_and_conditions_error').removeClass('d-none');
            return false;
        } else {
            $('#terms_and_conditions_error').addClass('d-none');
            $('#terms_and_conditions_form').submit();
        }
    });

    /* Form validation for About Us */
    $('#about_us_submit').on('click', function (event) {
        event.preventDefault();

        // Find the TinyMCE editor in About Us form
        var aboutEditor = null;
        tinymce.editors.forEach(function (editor) {
            if ($(editor.getElement()).closest('#about_us_form').length > 0) {
                aboutEditor = editor;
            }
        });

        var about_us = '';
        if (aboutEditor) {
            about_us = aboutEditor.getContent();
            // Update textarea with TinyMCE content
            $(aboutEditor.getElement()).val(about_us);
        } else {
            // Fallback to textarea value
            about_us = $('#about_us_form #tinymce_editor').val();
        }

        if (about_us.trim() === "" || about_us === "<p><br></p>" || about_us === "<p></p>") {
            $('#about_us_error').removeClass('d-none');
            return false;
        } else {
            $('#about_us_error').addClass('d-none');
            $('#about_us_form').submit();
        }
    });
});

// Keep your existing TinyMCE initialization exactly as it was:
var mode = $("body").attr('data-bs-theme');

if (mode == "dark") {
    tinymce.init({
        selector: "#tinymce_editor",
        skin: window.matchMedia("(prefers-color-scheme: dark)").matches ? "oxide-dark" : "oxide",
        content_css: window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "default",
        height: 400
    });
}

/* Rss Feed Models*/
$(document).ready(function () {
    $('#channels_id').select2()
})

$(document).ready(function () {
    $('#topics_id').select2()
})


// //  <><><><><><><> ADD JS FOR DRAG AND DROP REORDERING NEWS LANGUAGES <><><><><><><><><><>
// $(document).ready(function () {
//     // Set up CSRF token for all AJAX requests
//     $.ajaxSetup({
//         headers: {
//             'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')

//         }
//     });

//     // Enable drag-and-drop sorting
//     $("#sortable tbody").sortable({
//         cursor: "move",
//         placeholder: "sortable-placeholder",
//         helper: function (e, tr) {
//             var $originals = tr.children();
//             var $helper = tr.clone();
//             $helper.children().each(function (index) {
//                 $(this).width($originals.eq(index).width());
//             });
//             return $helper;
//         },
//         stop: function (event, ui) {
//             updatePosition(); // Update position after drag-and-drop
//         }
//     }).disableSelection();

//     // Handle input change in position number field
//     $(document).on('change', '.reorder-input', function () {
//         let rows = [];

//         // Collect rows and their position values
//         $('#sortable tbody tr').each(function () {
//             const positionVal = parseInt($(this).find('.reorder-input').val()) || 9999;
//             const rowId = $(this).data('id');
//             rows.push({
//                 id: rowId,
//                 position: positionVal,
//                 html: $(this).prop('outerHTML')
//             });
//         });

//         // Sort rows by position number
//         rows.sort((a, b) => a.position - b.position);

//         // Update table and renumber inputs
//         const $tbody = $('#sortable tbody');
//         $tbody.html('');
//         rows.forEach((row, index) => {
//             const $row = $(row.html);
//             $row.find('.reorder-input').val(index + 1);
//             $tbody.append($row);
//         });

//         // Save new position to server
//         updatePosition();
//     });

//     // Function to update position on server
//     function updatePosition() {
//         let positionData = [];
//         $('#sortable tbody tr').each(function (index) {
//             const id = $(this).data('id');
//             const position = index + 1;
//             $(this).find('.reorder-input').val(position); // Ensure input reflects position
//             positionData.push({
//                 id: id,
//                 position: position
//             });
//         });

//         $.ajax({

//             url: window.baseurl + 'admin/news-languages/reorder',
//             method: 'POST',
//             data: {
//                 order: positionData
//             },
//             success: function (response) {
//                 if (response.success) {
//                     // Find the index of the DEFAULT_LANGUAGE column
//                     let badgeColumnIndex = -1;
//                     $('#sortable thead th').each(function (index) {
//                         if ($(this).text().trim() === 'DEFAULT_LANGUAGE') {
//                             badgeColumnIndex = index;
//                             return false; // Break loop
//                         }
//                     });

//                     // Update the badge for each row
//                     if (badgeColumnIndex !== -1) {
//                         $('#sortable tbody tr').each(function (index) {
//                             const $badgeCell = $(this).find('td').eq(badgeColumnIndex);
//                             if (index === 0) {
//                                 $badgeCell.html('<span class="badge bg-success text-white">YES</span>');
//                             } else {
//                                 $badgeCell.html('<span class="badge bg-danger text-white">NO</span>');
//                             }
//                         });
//                     }

//                     Swal.fire({
//                         icon: 'success',
//                         title: 'Success',
//                         text: response.message,
//                         confirmButtonText: 'OK',
//                         allowOutsideClick: false, // prevent closing on outside click
//                         allowEscapeKey: false,    // prevent closing on ESC
//                         allowEnterKey: true       // allow closing on pressing Enter
//                     }).then((result) => {
//                         if (result.isConfirmed) {
//                             location.reload(); // Reload the page after clicking OK
//                         }
//                     });

//                 } else {
//                     Swal.fire({
//                         icon: 'error',
//                         title: 'Error',
//                         text: response.message
//                     });
//                 }
//             }

//         });
//     }
// });
// //  <><><><><><><> END JS OF DRAG AND DROP REORDERING NEWS LANGUAGES <><><><><><><>

//  <><><><><><><> ADD JS FOR DRAG AND DROP REORDERING NEWS LANGUAGES <><><><><><><><><><>
$(document).ready(function () {
    // Set up CSRF token for all AJAX requests
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // ✅ Get permission from data attribute in table
    let canReorder = $("#sortable tbody tr td.default-lang-cell").first().data("can-reorder") == "1";

    if (canReorder) {
        $("#sortable tbody").sortable({
            cursor: "move",
            placeholder: "sortable-placeholder",
            helper: function (e, tr) {
                var $originals = tr.children();
                var $helper = tr.clone();
                $helper.children().each(function (index) {
                    $(this).width($originals.eq(index).width());
                });
                return $helper;
            },
            stop: function () {
                updatePosition();
            }
        }).disableSelection();
    } else {
        $("#sortable tbody").sortable({
            cancel: "tr"
        });

        $("#sortable tbody").on("mousedown", "tr", function (e) {
            if (
                $(e.target).is("a, button, input, select, textarea, i, svg, span") ||
                $(e.target).closest("a, button").length
            ) {
                return;
            }

            Swal.fire({
                icon: 'info',
                title: 'No Permission',
                text: 'You do not have permission to reorder or set default language.',
                confirmButtonText: 'OK'
            });
            e.preventDefault();
        });
    }

    // Handle manual input change in position number field
    $(document).on('change', '.reorder-input', function () {
        if (!canReorder) {
            Swal.fire({
                icon: 'info',
                title: 'No Permission',
                text: 'You do not have permission to reorder or set default language.',
                confirmButtonText: 'OK'
            });
            // Reset value back to original sequence
            let index = $(this).closest("tr").index() + 1;
            $(this).val(index);
            return;
        }

        let rows = [];

        // Collect rows and their position values
        $('#sortable tbody tr').each(function () {
            const positionVal = parseInt($(this).find('.reorder-input').val()) || 9999;
            const rowId = $(this).data('id');
            rows.push({
                id: rowId,
                position: positionVal,
                element: $(this).detach() // detach keeps events & DOM intact
            });
        });

        // Sort rows by entered position number
        rows.sort((a, b) => a.position - b.position);

        // Re-append sorted rows
        const $tbody = $('#sortable tbody');
        rows.forEach((row, index) => {
            row.element.find('.reorder-input').val(index + 1);
            $tbody.append(row.element);
        });

        // Save new position to server
        updatePosition();
    });

    // Function to update position on server
    function updatePosition() {
        let positionData = [];
        $('#sortable tbody tr').each(function (index) {
            const id = $(this).data('id');
            const position = index + 1;
            $(this).find('.reorder-input').val(position); // Ensure input reflects position
            positionData.push({ id: id, position: position });
        });

        $.ajax({
            url: window.baseurl + 'admin/news-languages/reorder',
            method: 'POST',
            data: { order: positionData },
            success: function (response) {
                if (response.success) {
                    // Find the index of the DEFAULT_LANGUAGE column
                    let badgeColumnIndex = -1;
                    $('#sortable thead th').each(function (index) {
                        if ($(this).text().trim() === 'DEFAULT_LANGUAGE') {
                            badgeColumnIndex = index;
                            return false;
                        }
                    });

                    // Update the badge for each row
                    if (badgeColumnIndex !== -1) {
                        $('#sortable tbody tr').each(function (index) {
                            const $badgeCell = $(this).find('td').eq(badgeColumnIndex);
                            if (index === 0) {
                                $badgeCell.html('<span class="badge bg-success text-white">YES</span>');
                            } else {
                                $badgeCell.html('<span class="badge bg-danger text-white">NO</span>');
                            }
                        });
                    }

                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: response.message,
                        confirmButtonText: 'OK',
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        allowEnterKey: true
                    }).then((result) => {
                        if (result.isConfirmed) {
                            location.reload();
                        }
                    });

                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: response.message
                    });
                }
            }
        });
    }
});
//  <><><><><><><> END JS OF DRAG AND DROP REORDERING NEWS LANGUAGES <><><><><><><><><><>

//  <><><><><><><> START JS FOR CHANGE THEME <><><><><><><>
document.addEventListener("DOMContentLoaded", function () {
    var themeConfig = {
        theme: "light",
        "theme-base": "gray",
        "theme-font": "sans-serif",
        "theme-primary": "blue",
        "theme-radius": "1",
    };

    var url = new URL(window.location);
    var form = document.getElementById("offcanvasSettings");
    var resetButton = document.getElementById("reset-changes");
    var saveButton = form.querySelector('a.btn-primary'); // Save settings button

    // Apply saved theme from localStorage or defaults to document.documentElement
    function applyThemeFromStorage() {
        for (var key in themeConfig) {
            var value = window.localStorage.getItem("tabler-" + key) || themeConfig[key];
            if (value) {
                document.documentElement.setAttribute("data-bs-" + key, value);
            }
        }
    }

    // Update radio inputs to match saved theme or defaults
    function checkItems() {
        for (var key in themeConfig) {
            var value = window.localStorage.getItem("tabler-" + key) || themeConfig[key];
            if (value) {
                var radios = form.querySelectorAll(`[name="${key}"]`);
                radios.forEach((radio) => {
                    radio.checked = radio.value === value;
                });
            }
        }
    }

    // When "Save settings" clicked, save selected values and apply them
    saveButton.addEventListener("click", function (event) {
        event.preventDefault();

        var formData = new FormData(form);
        for (var key in themeConfig) {
            var value = formData.get(key) || themeConfig[key];
            window.localStorage.setItem("tabler-" + key, value);
            document.documentElement.setAttribute("data-bs-" + key, value);
            url.searchParams.set(key, value);
        }
        window.history.pushState({}, "", url);

        // Close offcanvas manually (Bootstrap 5 way)
        var offcanvas = bootstrap.Offcanvas.getInstance(form);
        if (offcanvas) {
            offcanvas.hide();
        }
    });

    // Reset changes: clear localStorage, reset radios, apply default theme immediately
    resetButton.addEventListener("click", function () {
        for (var key in themeConfig) {
            window.localStorage.removeItem("tabler-" + key);
            document.documentElement.removeAttribute("data-bs-" + key);
            url.searchParams.delete(key);
        }
        checkItems();
        applyThemeFromStorage();
        window.history.pushState({}, "", url);
    });

    // On page load: apply saved theme and set form inputs accordingly
    applyThemeFromStorage();
    checkItems();
});
//  <><><><><><><> START JS FOR CHANGE THEME <><><><><><><>

//  <><><><><><><> START JS FOR FREE TRIAL STATUS SETTINGS <><><><><><><>
// document.addEventListener('DOMContentLoaded', function () {
//     const freeTrialSwitch = document.getElementById('switch_free_trial_status');
//     const freeTrialStatusInput = document.getElementById('free_trial_status');
//     const postLimitInput = document.getElementById('free_trial_post_limit');
//     const storyLimitInput = document.getElementById('free_trial_story_limit');
//     const epaperLimitInput = document.getElementById('free_trial_e_papers_and_magazines_limit');

//     function updateLimitInputs() {
//         if (freeTrialSwitch.checked) {
//             freeTrialStatusInput.value = 1;
//             postLimitInput.value = -1;
//             storyLimitInput.value = -1;
//             epaperLimitInput.value = -1;

//             postLimitInput.setAttribute('readonly', 'readonly');
//             storyLimitInput.setAttribute('readonly', 'readonly');
//             epaperLimitInput.setAttribute('readonly', 'readonly');
//         } else {
//             freeTrialStatusInput.value = 0;
//             postLimitInput.removeAttribute('readonly');
//             storyLimitInput.removeAttribute('readonly');
//             epaperLimitInput.removeAttribute('readonly');
//             // Optionally reset to default values or leave as is
//             if (postLimitInput.value === '-1') postLimitInput.value = '';
//             if (storyLimitInput.value === '-1') storyLimitInput.value = '';
//             if (epaperLimitInput.value === '-1') epaperLimitInput.value = '';
//         }
//     }

//     // Initial check to set the correct state on page load
//     updateLimitInputs();

//     // Add event listener for changes to the switch
//     freeTrialSwitch.addEventListener('change', updateLimitInputs);
// });
document.addEventListener('DOMContentLoaded', function () {
    const freeTrialSwitch = document.getElementById('switch_free_trial_status');
    const freeTrialStatusInput = document.getElementById('free_trial_status');
    const postLimitInput = document.getElementById('free_trial_post_limit');
    const storyLimitInput = document.getElementById('free_trial_story_limit');
    const epaperLimitInput = document.getElementById('free_trial_e_papers_and_magazines_limit');

    // Check if all required elements exist
    if (!freeTrialSwitch || !freeTrialStatusInput || !postLimitInput || !storyLimitInput || !epaperLimitInput) {
        return; // Exit early to avoid errors
    }

    function updateLimitInputs() {
        if (freeTrialSwitch.checked) {
            freeTrialStatusInput.value = 1;
            postLimitInput.value = -1;
            storyLimitInput.value = -1;
            epaperLimitInput.value = -1;

            postLimitInput.setAttribute('readonly', 'readonly');
            storyLimitInput.setAttribute('readonly', 'readonly');
            epaperLimitInput.setAttribute('readonly', 'readonly');
        } else {
            freeTrialStatusInput.value = 0;
            postLimitInput.removeAttribute('readonly');
            storyLimitInput.removeAttribute('readonly');
            epaperLimitInput.removeAttribute('readonly');

            if (postLimitInput.value === '-1') postLimitInput.value = '';
            if (storyLimitInput.value === '-1') storyLimitInput.value = '';
            if (epaperLimitInput.value === '-1') epaperLimitInput.value = '';
        }
    }

    updateLimitInputs();
    freeTrialSwitch.addEventListener('change', updateLimitInputs);
});

//  <><><><><><><> END JS OF FREE TRIAL STATUS SETTINGS <><><><><><><>

//  <><><><><><><> START JS FOR FREE TRIAL MODE IN  SETTINGS <><><><><><><>
document.addEventListener('DOMContentLoaded', function () {
    const toggle = document.getElementById('switch_free_trial_status');
    const hiddenInput = document.getElementById('free_trial_status');

    if (toggle && hiddenInput) {
        const hasActiveSubscription = toggle.dataset.hasActiveSubscription === '1';

        toggle.addEventListener('change', function (e) {
            if (this.checked && hasActiveSubscription) {
                this.checked = false;
                hiddenInput.value = 0;

                Swal.fire({
                    icon: 'error',
                    title: 'Not Allowed',
                    text: 'You cannot activate Free Trial Mode because some users already have active subscriptions.',
                    allowOutsideClick: false,
                    allowEscapeKey: false,
                    allowEnterKey: true
                }).then(() => {
                    // Redirect to another page after user clicks "OK"
                    window.location.reload(); // change this to your desired URL
                });

                e.preventDefault();
            } else {
                hiddenInput.value = this.checked ? 1 : 0;
            }
        });
    }
});

//  <><><><><><><> END JS OF  FREE TRIAL MODE IN  SETTINGS <><><><><><><>



//  <><><><><><><> START JS FOR SEARCH ON SETTINGS <><><><><><><>
const currencySymbols = {
    'USD': '$',
    'AED': 'د.إ',
    'AFN': '؋',
    'ALL': 'L',
    'AMD': '֏',
    'ANG': 'ƒ',
    'AOA': 'Kz',
    'ARS': '$',
    'AUD': 'A$',
    'AWG': 'ƒ',
    'AZN': '₼',
    'BAM': 'KM',
    'BBD': '$',
    'BDT': '৳',
    'BGN': 'лв',
    'BMD': '$',
    'BND': '$',
    'BOB': 'Bs.',
    'BRL': 'R$',
    'BSD': '$',
    'BWP': 'P',
    'BYN': 'Br',
    'BZD': 'BZ$',
    'CAD': 'C$',
    'CDF': 'FC',
    'CHF': 'Fr',
    'CNY': '¥',
    'COP': '$',
    'CRC': '₡',
    'CVE': '$',
    'CZK': 'Kč',
    'DKK': 'kr',
    'DOP': 'RD$',
    'DZD': 'د.ج',
    'EGP': 'E£',
    'ETB': 'Br',
    'EUR': '€',
    'FJD': '$',
    'FKP': '£',
    'GBP': '£',
    'GEL': '₾',
    'GIP': '£',
    'GMD': 'D',
    'GTQ': 'Q',
    'GYD': '$',
    'HKD': 'HK$',
    'HNL': 'L',
    'HTG': 'G',
    'HUF': 'Ft',
    'IDR': 'Rp',
    'ILS': '₪',
    'INR': '₹',
    'ISK': 'kr',
    'JMD': '$',
    'JPY': '¥',
    'KES': 'KSh',
    'KGS': 'сом',
    'KHR': '៛',
    'KYD': '$',
    'KZT': '₸',
    'LAK': '₭',
    'LBP': 'ل.ل',
    'LKR': 'Rs',
    'LRD': '$',
    'LSL': 'L',
    'MAD': 'د.م.',
    'MDL': 'L',
    'MKD': 'ден',
    'MMK': 'K',
    'MNT': '₮',
    'MOP': 'P',
    'MUR': '₨',
    'MVR': 'ރ',
    'MWK': 'MK',
    'MXN': '$',
    'MYR': 'RM',
    'MZN': 'MT',
    'NAD': '$',
    'NGN': '₦',
    'NIO': 'C$',
    'NOK': 'kr',
    'NPR': '₨',
    'NZD': 'NZ$',
    'PAB': 'B/.',
    'PEN': 'S/',
    'PGK': 'K',
    'PHP': '₱',
    'PKR': '₨',
    'PLN': 'zł',
    'QAR': 'ر.ق',
    'RON': 'lei',
    'RSD': 'дин.',
    'RUB': '₽',
    'SAR': 'ر.س',
    'SBD': '$',
    'SCR': '₨',
    'SEK': 'kr',
    'SGD': 'S$',
    'SHP': '£',
    'SLE': 'Le',
    'SOS': 'S',
    'SRD': '$',
    'STD': 'Db',
    'SZL': 'L',
    'THB': '฿',
    'TJS': 'ЅМ',
    'TOP': 'T$',
    'TRY': '₺',
    'TTD': 'TT$',
    'TWD': 'NT$',
    'TZS': 'TSh',
    'UAH': '₴',
    'UYU': '$U',
    'UZS': "so'm",
    'WST': 'T',
    'XCD': '$',
    'YER': '﷼',
    'ZAR': 'R',
    'ZMW': 'ZK'
};

$(document).ready(function () {
    // Hide all gateway forms initially
    $('.gateway-form').hide();

    // Show the first form by default (optional, remove if you want no form visible initially)
    $('#stripe-form').show();

    // Handle button clicks
    $('button[data-gateway]').on('click', function () {
        // Hide all forms
        $('.gateway-form').hide();
        // Show the selected form
        const gateway = $(this).data('gateway');
        $(`#${gateway}-form`).show();
    });

    // For Stripe
    $('#switch_stripe_gateway').on('change', function () {
        $('#stripe_gateway').val($(this).is(':checked') ? '1' : '0');
    });

    // For Razorpay
    $('#switch_razorpay_gateway').on('change', function () {
        $('#razorpay_gateway').val($(this).is(':checked') ? '1' : '0');
    });
    // For Apple Pau
    $('#switch_applepay_gateway').on('change', function () {
        $('#applepay_gateway').val($(this).is(':checked') ? '1' : '0');
    });

    function updateCurrencySymbol(selectElement, symbolField, hiddenField) {
        const selectedCurrency = $(selectElement).val();
        const symbol = currencySymbols[selectedCurrency] || selectedCurrency;
        $(symbolField).val(symbol);
        $(hiddenField).val(symbol); // Update hidden field
    }

    // Set initial values
    updateCurrencySymbol('#stripe_currency_code', '#stripe_currency_symbol',
        '#stripe_currency_symbol_hidden');


    updateCurrencySymbol('#razorpay_currency_code', '#razorpay_currency_symbol',
        '#razorpay_currency_symbol_hidden');

    updateCurrencySymbol('#applepay_currency_code', '#applepay_currency_symbol',
        '#applepay_currency_symbol_hidden');

    updateCurrencySymbol('#custom_ads_currency_code', '#custom_ads_currency_symbol',
        '#custom_ads_currency_symbol_hidden');
    // Add event listeners for changes
    $('#stripe_currency_code').on('change', function () {
        updateCurrencySymbol('#stripe_currency_code', '#stripe_currency_symbol',
            '#stripe_currency_symbol_hidden');
    });

    $('#razorpay_currency_code').on('change', function () {
        updateCurrencySymbol('#razorpay_currency_code', '#razorpay_currency_symbol',
            '#razorpay_currency_symbol_hidden');
    });

    $('#applepay_currency_code').on('change', function () {
        updateCurrencySymbol('#applepay_currency_code', '#applepay_currency_symbol',
            '#applepay_currency_symbol_hidden');
    });

    $('#custom_ads_currency_code').on('change', function () {
        updateCurrencySymbol('#custom_ads_currency_code', '#custom_ads_currency_symbol',
            '#custom_ads_currency_symbol_hidden');
    });
    // Initialize select2
    $('#stripe_currency_code').val($('#stripe_currency_code').data('currency-code')).trigger('change');
    $('#custom_ads_currency_code').val($('#custom_ads_currency_code').data('currency-code')).trigger('change');
    $('#razorpay_currency_code').val($('#razorpay_currency_code').data('currency-code')).trigger('change');
    $('#applepay_currency_code').val($('#applepay_currency_code').data('currency-code')).trigger('change');
});

//  <><><><><><><> END JS OF SEARCH ON SETTINGS <><><><><><><>

//  <><><><><><><> START JS FOR ROLE EDIT BUTTON<><><><><><><>
$('#edit_role_submit_button').on('click', function (e) {
    const btn = document.getElementById("edit_role_submit_button");
    btn.disabled = false;
    const observer = new MutationObserver(() => {
        if (btn.disabled) {
            btn.disabled = false;
        }
    });
    observer.observe(btn, { attributes: true, attributeFilter: ['disabled'] });
});
//  <><><><><><><> END JS OF ROLE EDIT BUTTON <><><><><><><>
document.addEventListener('DOMContentLoaded', function () {
    // Global Select All
    const globalSelectAll = document.getElementById('selectAllGlobal');

    // If no global select all and no permissions — exit safely
    const allPermissionCheckboxes = document.querySelectorAll('input[name="permission[]"]');
    const moduleSelectAlls = document.querySelectorAll('[id^="selectAllModule"]');

    if (!globalSelectAll && allPermissionCheckboxes.length === 0 && moduleSelectAlls.length === 0) {
        return; // Nothing to initialize
    }

    if (globalSelectAll) {
        globalSelectAll.addEventListener('change', function () {
            const allCheckboxes = document.querySelectorAll('input[name="permission[]"]');
            const allModuleSelects = document.querySelectorAll('[id^="selectAllModule"]');

            allCheckboxes.forEach(checkbox => {
                checkbox.checked = this.checked;
            });

            allModuleSelects.forEach(checkbox => {
                checkbox.checked = this.checked;
                checkbox.indeterminate = false;
            });
        });
    }

    // Module Select Alls
    if (moduleSelectAlls.length > 0) {
        moduleSelectAlls.forEach(selectAll => {
            const moduleIndex = selectAll.id.replace('selectAllModule', '');
            const moduleCheckboxes = document.querySelectorAll('.module-' + moduleIndex);

            selectAll.addEventListener('change', function () {
                moduleCheckboxes.forEach(checkbox => {
                    checkbox.checked = this.checked;
                });

                updateGlobalSelectAll();
            });
        });
    }

    // Individual checkbox change
    if (allPermissionCheckboxes.length > 0) {
        allPermissionCheckboxes.forEach(checkbox => {
            checkbox.addEventListener('change', function () {
                const classList = Array.from(this.classList);
                const moduleClass = classList.find(cls => cls.startsWith('module-'));
                if (moduleClass) {
                    const moduleIndex = moduleClass.replace('module-', '');
                    updateModuleSelectAll(moduleIndex);
                }

                updateGlobalSelectAll();
            });
        });
    }

    function updateModuleSelectAll(moduleIndex) {
        const moduleCheckboxes = document.querySelectorAll('.module-' + moduleIndex);
        const moduleSelectAll = document.getElementById('selectAllModule' + moduleIndex);

        if (!moduleSelectAll || moduleCheckboxes.length === 0) return;

        const allChecked = Array.from(moduleCheckboxes).every(cb => cb.checked);
        const someChecked = Array.from(moduleCheckboxes).some(cb => cb.checked);

        moduleSelectAll.checked = allChecked;
        moduleSelectAll.indeterminate = someChecked && !allChecked;
    }

    function updateGlobalSelectAll() {
        const globalSelectAll = document.getElementById('selectAllGlobal');
        const allCheckboxes = document.querySelectorAll('input[name="permission[]"]');

        if (!globalSelectAll || allCheckboxes.length === 0) return;

        const allChecked = Array.from(allCheckboxes).every(cb => cb.checked);
        const someChecked = Array.from(allCheckboxes).some(cb => cb.checked);

        globalSelectAll.checked = allChecked;
        globalSelectAll.indeterminate = someChecked && !allChecked;
    }
});

(function () {
    'use strict';

    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initializePermissions);
    } else {
        initializePermissions();
    }

    function initializePermissions() {
        const globalSelectAll = document.getElementById('selectAllGlobal');
        const allPermissionCheckboxes = document.querySelectorAll('input[name="permission[]"]');
        const moduleSelectAlls = document.querySelectorAll('[id^="selectAllModule"]');

        // If there are no permissions or select-alls, safely exit
        if (!globalSelectAll && moduleSelectAlls.length === 0 && allPermissionCheckboxes.length === 0) {
            return;
        }

        // Initialize select all states after short delay
        setTimeout(initializeSelectAllStates, 100);

        // Global Select All logic
        if (globalSelectAll) {
            globalSelectAll.addEventListener('change', function () {
                const allCheckboxes = document.querySelectorAll('input[name="permission[]"]');
                const allModuleSelects = document.querySelectorAll('[id^="selectAllModule"]');

                allCheckboxes.forEach(checkbox => {
                    checkbox.checked = this.checked;
                });

                allModuleSelects.forEach(checkbox => {
                    checkbox.checked = this.checked;
                    checkbox.indeterminate = false;
                });
            });
        }

        // Module Select All logic
        if (moduleSelectAlls.length > 0) {
            moduleSelectAlls.forEach(selectAll => {
                const moduleIndex = selectAll.id.replace('selectAllModule', '');
                const moduleCheckboxes = document.querySelectorAll('.module-' + moduleIndex);

                selectAll.addEventListener('change', function () {
                    moduleCheckboxes.forEach(checkbox => {
                        checkbox.checked = this.checked;
                    });
                    updateGlobalSelectAll();
                });
            });
        }

        // Individual checkbox change logic
        if (allPermissionCheckboxes.length > 0) {
            allPermissionCheckboxes.forEach(checkbox => {
                checkbox.addEventListener('change', function () {
                    const moduleClass = Array.from(this.classList).find(cls => cls.startsWith('module-'));
                    if (moduleClass) {
                        const moduleIndex = moduleClass.replace('module-', '');
                        updateModuleSelectAll(moduleIndex);
                    }
                    updateGlobalSelectAll();
                });
            });
        }
    }

    function initializeSelectAllStates() {
        const moduleSelectAlls = document.querySelectorAll('[id^="selectAllModule"]');
        if (moduleSelectAlls.length > 0) {
            moduleSelectAlls.forEach(selectAll => {
                const moduleIndex = selectAll.id.replace('selectAllModule', '');
                updateModuleSelectAll(moduleIndex);
            });
        }
        updateGlobalSelectAll();
    }

    function updateModuleSelectAll(moduleIndex) {
        const moduleCheckboxes = document.querySelectorAll('.module-' + moduleIndex);
        const moduleSelectAll = document.getElementById('selectAllModule' + moduleIndex);

        if (!moduleSelectAll || moduleCheckboxes.length === 0) return;

        const allChecked = Array.from(moduleCheckboxes).every(cb => cb.checked);
        const someChecked = Array.from(moduleCheckboxes).some(cb => cb.checked);

        moduleSelectAll.checked = allChecked;
        moduleSelectAll.indeterminate = someChecked && !allChecked;
    }

    function updateGlobalSelectAll() {
        const globalSelectAll = document.getElementById('selectAllGlobal');
        const allCheckboxes = document.querySelectorAll('input[name="permission[]"]');

        if (!globalSelectAll || allCheckboxes.length === 0) return;

        const allChecked = Array.from(allCheckboxes).every(cb => cb.checked);
        const someChecked = Array.from(allCheckboxes).some(cb => cb.checked);

        globalSelectAll.checked = allChecked;
        globalSelectAll.indeterminate = someChecked && !allChecked;
    }
})();

$(document).ready(function () {
    const newsLangSelect = $('#news_language_id');
    let channelSelectWrapper;
    let topicSelectWrapper;

    const topicSelect = $('#select-topic');

    if (topicSelect.length && topicSelect.closest('div.col-sm-6').length) {
        topicSelectWrapper = topicSelect.closest('div.col-sm-6');
    } else {
        topicSelectWrapper = $('div.topic-none');
    }

    const channelSelect = $('#add_channel_id');
    if (channelSelect.length && channelSelect.closest('div.col-sm-6').length) {
        channelSelectWrapper = channelSelect.closest('div.col-sm-6');
    } else {
        channelSelectWrapper = $('div.channel-none');
    }

    if (!newsLangSelect.length) return;

    const channelPlaceholder = channelSelect.length ? channelSelect.find('option:first').clone() : null;
    const topicPlaceholder = topicSelect.length ? topicSelect.find('option:first').clone() : null;

    const selectedLangId = newsLangSelect.val() || null;
    const selectedChannelId = channelSelect.length ? channelSelect.val() : null;
    const selectedTopicId = topicSelect.length ? topicSelect.val() : null;

    function resetSelect(selectEl, placeholder) {
        if (selectEl.length && placeholder) {
            selectEl.empty().append(placeholder.clone());
        }
    }

    function toggleVisibility(wrapper, show) {
        if (show) {
            wrapper.removeClass('d-none');
        } else {
            wrapper.addClass('d-none');
        }
    }

    function loadLanguageData(newsLangId, selectedChannelId = null, selectedTopicId = null) {
        if (!newsLangId) {
            resetSelect(channelSelect, channelPlaceholder);
            resetSelect(topicSelect, topicPlaceholder);
            toggleVisibility(channelSelectWrapper, false);
            toggleVisibility(topicSelectWrapper, false);
            return;
        }

        // Fetch channels
        if (channelSelect.length) {
            $.ajax({
                url: '/admin/get-channels-by-language',
                data: { news_language_id: newsLangId },
                success: function (res) {
                    resetSelect(channelSelect, channelPlaceholder);
                    if (res.channels?.length) {
                        res.channels.forEach(c => {
                            const selected = (selectedChannelId == c.id) ? 'selected' : '';
                            channelSelect.append(`<option value="${c.id}" ${selected}>${c.name}</option>`);
                        });
                        toggleVisibility(channelSelectWrapper, true);
                    } else {
                        toggleVisibility(channelSelectWrapper, false);
                    }
                },
            });
        }

        // Fetch topics
        if (topicSelect.length) {
            $.ajax({
                url: '/admin/get-topics-by-language',
                data: { news_language_id: newsLangId },
                success: function (res) {
                    resetSelect(topicSelect, topicPlaceholder);
                    if (res.topics?.length) {
                        res.topics.forEach(t => {
                            const selected = (selectedTopicId == t.id) ? 'selected' : '';
                            topicSelect.append(`<option value="${t.id}" ${selected}>${t.name}</option>`);
                        });
                        toggleVisibility(topicSelectWrapper, true);
                    } else {
                        toggleVisibility(topicSelectWrapper, false);
                    }
                },
            });
        }
    }

    // On language change
    newsLangSelect.on('change', function () {
        const newsLangId = $(this).val();
        loadLanguageData(newsLangId);
    });

    // Load existing selections in edit mode
    if (selectedLangId) {
        loadLanguageData(selectedLangId, selectedChannelId, selectedTopicId);
    } else {
        resetSelect(channelSelect, channelPlaceholder);
        resetSelect(topicSelect, topicPlaceholder);
        toggleVisibility(channelSelectWrapper, false);
        toggleVisibility(topicSelectWrapper, false);
    }
});

$(document).ready(function () {
    // Trigger when the modal is opened
    $('#editRssFeedModal').on('shown.bs.modal', function () {
        const newsLangSelect = $('#edit_news_language_id');
        const channelSelect = $('#edit_channel_name');
        const topicSelect = $('#edit_topic_name');

        // Check if news language dropdown exists
        if (!newsLangSelect.length) {
            return;
        }

        // Create placeholders dynamically
        const channelPlaceholder = channelSelect.length ? channelSelect.find('option:first').clone() : null;
        const topicPlaceholder = topicSelect.length ? topicSelect.find('option:first').clone() : null;

        // Detect preselected values (useful for edit modal)
        const selectedLangId = newsLangSelect.val() || null;
        const selectedChannelId = channelSelect.length ? channelSelect.val() : null;
        const selectedTopicId = topicSelect.length ? topicSelect.val() : null;

        function resetSelect(selectEl, placeholder) {
            if (selectEl.length && placeholder) {
                selectEl.empty().append(placeholder.clone());
            }
        }

        function loadLanguageData(newsLangId, selectedChannelId = null, selectedTopicId = null) {
            if (!newsLangId) {
                resetSelect(channelSelect, channelPlaceholder);
                resetSelect(topicSelect, topicPlaceholder);
                return;
            }

            // Fetch channels
            if (channelSelect.length) {
                $.ajax({
                    url: '/admin/get-channels-by-language',
                    data: { news_language_id: newsLangId },
                    success: function (res) {
                        resetSelect(channelSelect, channelPlaceholder);
                        if (res.channels?.length) {
                            res.channels.forEach(c => {
                                const selected = (selectedChannelId == c.id) ? 'selected' : '';
                                channelSelect.append(`<option value="${c.id}" ${selected}>${c.name}</option>`);
                            });
                        }
                    },
                });
            }

            // Fetch topics
            if (topicSelect.length) {
                $.ajax({
                    url: '/admin/get-topics-by-language',
                    data: { news_language_id: newsLangId },
                    success: function (res) {
                        resetSelect(topicSelect, topicPlaceholder);
                        if (res.topics?.length) {
                            res.topics.forEach(t => {
                                const selected = (selectedTopicId == t.id) ? 'selected' : '';
                                topicSelect.append(`<option value="${t.id}" ${selected}>${t.name}</option>`);
                            });
                        }
                    },
                });
            }
        }

        // On language change
        newsLangSelect.on('change', function () {
            const newsLangId = $(this).val();
            loadLanguageData(newsLangId);
        });

        // Load existing selections when modal opens
        if (selectedLangId) {
            loadLanguageData(selectedLangId, selectedChannelId, selectedTopicId);
        } else {
            resetSelect(channelSelect, channelPlaceholder);
            resetSelect(topicSelect, topicPlaceholder);
        }
    });
});


tinymce.init({
    selector: '#tinymce_editor',
    height: 400,
    plugins: 'link image code lists',
    toolbar: 'undo redo | styles | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist | link image code',
});